10 PRINT"Stuff programmed by Achim Haag"
20 PRINT "Visit http://home.t-online.de/home/Achim.Haag"
100 REM Program creates MIDI-Files to enable the Alesis QS Synth
110 REM to switch bank/program of another synth/expander
112 REM Do not forget to doubleclick on file in SoundBridge and select
114 REM option "Sequence data via output port" !
116 REM Play File with Program+"00"+<single-number-key>
118 REM Roland JV-2080 : Change Rx-Chnl in "GOSUB" (Variable RCVCHNL)
120 REM ==============================================================
130 REM *** Generate MIDI File Header ***
140 MIDHD$=CHR$(&H4D)+CHR$(&H54)+CHR$(&H68)+CHR$(&H64) : REM Midi Header
150 MIDHD$=MIDHD$+CHR$(0)+CHR$(0)+CHR$(0)+CHR$(6) : REM Len of Hdr is fixed 6
160 MIDHD$=MIDHD$+CHR$(0)+CHR$(0) : REM Hdr-Info Fileformat=0
170 MIDHD$=MIDHD$+CHR$(0)+CHR$(1) : REM Hdr-Info 1 MTrk Chunk
180 MIDHD$=MIDHD$+CHR$(0)+CHR$(96) : REM Hdr-Info 96 ppqn
200 REM ==============================================================
210 REM *** Generate Switch Roland JV-2080 User-Bank (MSB=80,LSB=0) ***
220 PRINT " 1 = Roland JV2080 Userbank"
222 PRINT " 2 = Roland JV2080 Preset-A Bank"
224 PRINT " 3 = Roland JV2080 Preset-B Bank"
226 PRINT " 4 = Roland JV2080 Card Bank"
230 INPUT "Enter number: ";ANSWR
240 ON ANSWR GOSUB 500,600,700,800 : REM Wrong number => GOSUB fails
250 IF MIDIFN$<>"" GOTO 300
260 PRINT"Midi-Filename not set, your selection ";ANSWR;" maybe wrong ?"
270 STOP
300 REM ==============================================================         l
310 REM *** Generate Track Chunk
320 MIDTR$=MIDTR$+CHR$(0)+CHR$(&HFF)+CHR$(&H2F)+CHR$(0) : REM End of Track
330 MIDTH$=CHR$(&H4D)+CHR$(&H54)+CHR$(&H72)+CHR$(&H6B) : REM Generate Track Hdr
340 MIDTH$=MIDTH$+CHR$(0)+CHR$(0)+CHR$(0)+CHR$(LEN(MIDTR$)): REM 4 byte track len
350 MIDTR$=MIDTH$+MIDTR$ : REM Track Chunk is Track Hdr + Data
400 REM ==============================================================
410 REM *** Write Midi-File to Dataset ***
420 OPEN MIDIFN$ FOR OUTPUT AS #1
430 PRINT #1,MIDHD$;
440 PRINT #1,MIDTR$;
450 CLOSE #1
460 PRINT"File '";MIDIFN$;" created"
470 END
500 REM =================== GOSUB - JV2080 User Bank =================
510 PRINT "*** Generate Switch Roland JV-2080 User-Bank (MSB=80,LSB=0) ***"
520 MIDIFN$="JV2080U.MID":COMMENT$="JV2080 User Bank"
530 RCVCHN=15 : REM JV-2080 Receive Channel / Control Channel as in Display
540 RCVCHNMSK=RCVCHN-1 : REM Roland Display starts with 1, is real zero
550 MIDTR$=CHR$(0)+CHR$(&HFF)+CHR$(3)+CHR$(LEN(COMMENT$))+COMMENT$ : REM Title
560 MIDTR$=MIDTR$+CHR$(0)+CHR$(&HFF)+CHR$(&H51)+CHR$(&H3)+CHR$(7)+CHR$(&HA1)+CHR$(&H20) : REM Tempo 120 bpm
570 MIDTR$=MIDTR$+CHR$(0)+CHR$(&HB0 OR RCVCHNMSK)+CHR$(0)+CHR$(80) : REM CC0=MSB=80
580 MIDTR$=MIDTR$+CHR$(&H30)+CHR$(&HB0 OR RCVCHNMSK)+CHR$(32)+CHR$(0): REM CC32=LSB=0
590 MIDTR$=MIDTR$+CHR$(&H30)+CHR$(&HC0 OR RCVCHNMSK)+CHR$(0): REM Prog Chg  #0
595 RETURN
600 REM =================== GOSUB - JV2080 Pr-A Bank =================
610 PRINT "*** Generate Switch Roland JV-2080 Preset-A-Bank (MSB=81,LSB=0) ***"
620 MIDIFN$="JV2080A.MID":COMMENT$="JV2080 Pr-A Bank"
630 RCVCHN=15 : REM JV-2080 Receive Channel / Control Channel as in Display
640 RCVCHNMSK=RCVCHN-1 : REM Roland Display starts with 1, is real zero
650 MIDTR$=CHR$(0)+CHR$(&HFF)+CHR$(3)+CHR$(LEN(COMMENT$))+COMMENT$ : REM Title
660 MIDTR$=MIDTR$+CHR$(0)+CHR$(&HFF)+CHR$(&H51)+CHR$(&H3)+CHR$(7)+CHR$(&HA1)+CHR$(&H20) : REM Tempo 120 bpm
670 MIDTR$=MIDTR$+CHR$(0)+CHR$(&HB0 OR RCVCHNMSK)+CHR$(0)+CHR$(81) : REM CC0=MSB=81
680 MIDTR$=MIDTR$+CHR$(&H30)+CHR$(&HB0 OR RCVCHNMSK)+CHR$(32)+CHR$(0): REM CC32=LSB=0
690 MIDTR$=MIDTR$+CHR$(&H30)+CHR$(&HC0 OR RCVCHNMSK)+CHR$(0): REM Prog Chg  #0
695 RETURN
700 REM =================== GOSUB - JV2080 Pr-B Bank =================
710 PRINT "*** Generate Switch Roland JV-2080 Preset-B-Bank (MSB=81,LSB=1) ***"
720 MIDIFN$="JV2080B.MID":COMMENT$="JV2080 Pr-B Bank"
730 RCVCHN=15 : REM JV-2080 Receive Channel / Control Channel as in Display
740 RCVCHNMSK=RCVCHN-1 : REM Roland Display starts with 1, is real zero
750 MIDTR$=CHR$(0)+CHR$(&HFF)+CHR$(3)+CHR$(LEN(COMMENT$))+COMMENT$ : REM Title
760 MIDTR$=MIDTR$+CHR$(0)+CHR$(&HFF)+CHR$(&H51)+CHR$(&H3)+CHR$(7)+CHR$(&HA1)+CHR$(&H20) : REM Tempo 120 bpm
770 MIDTR$=MIDTR$+CHR$(0)+CHR$(&HB0 OR RCVCHNMSK)+CHR$(0)+CHR$(81) : REM CC0=MSB=81
780 MIDTR$=MIDTR$+CHR$(&H30)+CHR$(&HB0 OR RCVCHNMSK)+CHR$(32)+CHR$(1): REM CC32=LSB=1
790 MIDTR$=MIDTR$+CHR$(&H30)+CHR$(&HC0 OR RCVCHNMSK)+CHR$(0): REM Prog Chg  #0
795 RETURN
800 REM =================== GOSUB - JV2080 Card Bank =================
810 PRINT "*** Generate Switch Roland JV-2080 Card-Bank (MSB=82,LSB=0) ***"
820 MIDIFN$="JV208CD.MID":COMMENT$="JV2080 Card Bank"
830 RCVCHN=15 : REM JV-2080 Receive Channel / Control Channel as in Display
840 RCVCHNMSK=RCVCHN-1 : REM Roland Display starts with 1, is real zero
850 MIDTR$=CHR$(0)+CHR$(&HFF)+CHR$(3)+CHR$(LEN(COMMENT$))+COMMENT$ : REM Title
860 MIDTR$=MIDTR$+CHR$(0)+CHR$(&HFF)+CHR$(&H51)+CHR$(&H3)+CHR$(7)+CHR$(&HA1)+CHR$(&H20) : REM Tempo 120 bpm
870 MIDTR$=MIDTR$+CHR$(0)+CHR$(&HB0 OR RCVCHNMSK)+CHR$(0)+CHR$(82) : REM CC0=MSB=81
880 MIDTR$=MIDTR$+CHR$(&H30)+CHR$(&HB0 OR RCVCHNMSK)+CHR$(32)+CHR$(0): REM CC32=LSB=1
890 MIDTR$=MIDTR$+CHR$(&H30)+CHR$(&HC0 OR RCVCHNMSK)+CHR$(0): REM Prog Chg  #0
895 RETURN
